/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.compat;

import com.mojang.logging.LogUtils;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.mc_utils.ServerTaskList;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.MyTaskList;

public class IPModInfoChecking {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final boolean IS_TEST = false;
    @Nullable
    private static List<String> incompatibleShaderpacks;
    @Nullable
    private static String lastShaderpackName;

    @Nullable
    public static ImmPtlInfo fetchImmPtlInfoFromInternet() {
        String url = O_O.getImmPtlModInfoUrl();
        if (url == null) {
            LOGGER.info("Not fetching iPortal mod info");
            return null;
        }
        try {
            HttpResponse<String> response = HttpClient.newHttpClient().send(HttpRequest.newBuilder().uri(URI.create(url)).header("User-Agent", "Immersive Portals mod").build(), HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                LOGGER.error("Failed to fetch iPortal mod info {}", (Object)response.statusCode());
                return null;
            }
            String jsonStr = response.body();
            ImmPtlInfo immPtlInfo = (ImmPtlInfo)Helper.gson.fromJson(jsonStr, ImmPtlInfo.class);
            LOGGER.info("iPortal mod info fetched");
            return immPtlInfo;
        }
        catch (Throwable e) {
            LOGGER.error("Failed to fetch iPortal mod info", e);
            return null;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void initClient() {
        class_156.method_18349().execute(() -> {
            if (!IPGlobal.checkModInfoFromInternet) {
                return;
            }
            ImmPtlInfo immPtlInfo = IPModInfoChecking.fetchImmPtlInfoFromInternet();
            if (immPtlInfo == null) {
                return;
            }
            incompatibleShaderpacks = immPtlInfo.incompatibleShaderpacks;
            List<class_5250> severeIncompatWarningText = IPModInfoChecking.getSevereIncompatWarningText(immPtlInfo);
            if (!severeIncompatWarningText.isEmpty()) {
                class_5250 class_52502 = severeIncompatWarningText.stream().reduce(class_2561.method_43473(), (a, b) -> a.method_27693("\n").method_10852((class_2561)b));
            }
            IPGlobal.CLIENT_TASK_LIST.addTask(MyTaskList.withDelayCondition(() -> class_310.method_1551().field_1687 == null, MyTaskList.oneShotTask(() -> {
                class_5250 text1;
                ArrayList<class_5250> texts = new ArrayList<class_5250>();
                if (IPGlobal.enableUpdateNotification && O_O.shouldUpdateImmPtl(immPtlInfo.latestReleaseVersion)) {
                    text1 = class_2561.method_43469((String)"imm_ptl.new_version_available", (Object[])new Object[]{immPtlInfo.latestReleaseVersion});
                    text1.method_10852((class_2561)McHelper.getLinkText(O_O.getModDownloadLink()));
                    text1.method_10852((class_2561)class_2561.method_43470((String)"  "));
                    text1.method_10852(IPMcHelper.getDisableUpdateCheckText());
                    texts.add(text1);
                }
                if (IPConfig.getConfig().shouldDisplayWarning("preview") && immPtlInfo.previewVersions.contains(O_O.getImmPtlVersionStr())) {
                    text1 = class_2561.method_43471((String)"imm_ptl.preview_warning").method_10852((class_2561)McHelper.getLinkText(O_O.getIssueLink())).method_27693(" ").method_10852(IPMcHelper.getDisableWarningText("preview"));
                    texts.add(text1);
                }
                texts.addAll(severeIncompatWarningText);
                for (ModIncompatInfo modIncompatInfo : immPtlInfo.incompatible) {
                    if (modIncompatInfo == null || !modIncompatInfo.isModLoadedWithinVersion() || !IPConfig.getConfig().shouldDisplayWarning(modIncompatInfo.modId)) continue;
                    class_5250 text12 = class_2561.method_43469((String)"imm_ptl.incompatible", (Object[])new Object[]{modIncompatInfo.modName, modIncompatInfo.modId}).method_27692(class_124.field_1061).method_10852(IPMcHelper.getDisableWarningText(modIncompatInfo.modId));
                    if (modIncompatInfo.desc != null) {
                        text12.method_10852((class_2561)class_2561.method_43470((String)(" " + modIncompatInfo.desc + " ")));
                    }
                    if (modIncompatInfo.link != null) {
                        text12.method_10852((class_2561)McHelper.getLinkText(" " + modIncompatInfo.link));
                    }
                    texts.add(text12);
                }
                for (class_2561 class_25612 : texts) {
                    CHelper.printChat(class_25612);
                }
            })));
        });
        IPGlobal.CLIENT_TASK_LIST.addTask(MyTaskList.withDelayCondition(() -> class_310.method_1551().field_1687 == null, MyTaskList.oneShotTask(() -> {
            List<ModContainer> topLevelMods;
            if (IPConfig.getConfig().shouldDisplayWarning("many_mods") && !FabricLoader.getInstance().isDevelopmentEnvironment() && (topLevelMods = FabricLoader.getInstance().getAllMods().stream().filter(modContainer -> modContainer.getContainingMod().isEmpty()).toList()).size() > 20) {
                CHelper.printChat((class_2561)class_2561.method_43470((String)"[Immersive Portals] WARNING: You are using many mods. It's likely that one of them has compatibility issues with Immersive Portals. If you are sure that there is no compatibility issue, disable this warning.").method_27692(class_124.field_1061).method_10852(IPMcHelper.getDisableWarningText("many_mods")));
            }
        })));
    }

    private static List<class_5250> getSevereIncompatWarningText(ImmPtlInfo immPtlInfo) {
        ArrayList<class_5250> texts = new ArrayList<class_5250>();
        for (ModIncompatInfo info : immPtlInfo.severelyIncompatible) {
            if (info == null || !info.isModLoadedWithinVersion()) continue;
            class_5250 text1 = info.startVersion != null || info.endVersion != null ? class_2561.method_43469((String)"imm_ptl.severely_incompatible_within_version", (Object[])new Object[]{info.modName, info.modId, info.getVersionRangeStr()}).method_27692(class_124.field_1061) : class_2561.method_43469((String)"imm_ptl.severely_incompatible", (Object[])new Object[]{info.modName, info.modId}).method_27692(class_124.field_1061);
            if (info.desc != null) {
                text1.method_10852((class_2561)class_2561.method_43470((String)(" " + info.desc + " ")));
            }
            if (info.link != null) {
                text1.method_10852((class_2561)class_2561.method_43470((String)" "));
                text1.method_10852((class_2561)McHelper.getLinkText(info.link));
            }
            texts.add(text1);
        }
        return texts;
    }

    public static void initDedicatedServer() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            if (!IPGlobal.checkModInfoFromInternet) {
                return;
            }
            ImmPtlInfo immPtlInfo = IPModInfoChecking.fetchImmPtlInfoFromInternet();
            if (immPtlInfo == null) {
                return;
            }
            ServerTaskList.of(server).addOneShotTask(() -> {
                class_5250 text1;
                if (IPGlobal.enableUpdateNotification && O_O.shouldUpdateImmPtl(immPtlInfo.latestReleaseVersion)) {
                    LOGGER.info("[Immersive Portals] A new version is available. It is recommended to update to " + immPtlInfo.latestReleaseVersion);
                }
                for (ModIncompatInfo mod : immPtlInfo.severelyIncompatible) {
                    if (mod == null || !mod.isModLoadedWithinVersion()) continue;
                    if (mod.startVersion != null || mod.endVersion != null) {
                        text1 = class_2561.method_43469((String)"imm_ptl.severely_incompatible_within_version", (Object[])new Object[]{mod.modName, mod.modId, mod.getVersionRangeStr()}).method_27692(class_124.field_1061);
                        LOGGER.error("[Immersive Portals] Detected an incompatible mod: {} {} version range: {} description: {} link: {}", new Object[]{mod.modName, mod.modId, mod.getVersionRangeStr(), mod.desc, mod.link});
                    } else {
                        text1 = class_2561.method_43469((String)"imm_ptl.severely_incompatible", (Object[])new Object[]{mod.modName, mod.modId}).method_27692(class_124.field_1061);
                        LOGGER.error("[Immersive Portals] Detected an incompatible mod: {} {} description: {} link: {}", new Object[]{mod.modName, mod.modId, mod.desc, mod.link});
                    }
                    if (mod.desc != null) {
                        text1.method_10852((class_2561)class_2561.method_43470((String)(" " + mod.desc + " ")));
                    }
                    if (mod.link != null) {
                        text1.method_10852((class_2561)class_2561.method_43470((String)" "));
                        text1.method_10852((class_2561)McHelper.getLinkText(mod.link));
                    }
                    McHelper.sendMessageToFirstLoggedPlayer(server, (class_2561)class_2561.method_43471((String)"imm_ptl.message_from_server").method_10852((class_2561)text1));
                }
                for (ModIncompatInfo mod : immPtlInfo.incompatible) {
                    if (mod == null || !mod.isModLoadedWithinVersion() || !IPConfig.getConfig().shouldDisplayWarning(mod.modId)) continue;
                    text1 = class_2561.method_43469((String)"imm_ptl.incompatible", (Object[])new Object[]{mod.modName, mod.modId}).method_27692(class_124.field_1061);
                    if (mod.desc != null) {
                        text1.method_10852((class_2561)class_2561.method_43470((String)(" " + mod.desc + " ")));
                    }
                    if (mod.link != null) {
                        text1.method_10852((class_2561)McHelper.getLinkText(" " + mod.link));
                    }
                    LOGGER.error("[Immersive Portals] Detected a mildly incompatible mod: {} {} description: {} link: {}", new Object[]{mod.modName, mod.modId, mod.desc, mod.link});
                    McHelper.sendMessageToFirstLoggedPlayer(server, (class_2561)class_2561.method_43471((String)"imm_ptl.message_from_server").method_10852((class_2561)text1));
                }
            });
        });
    }

    public static void checkShaderpack() {
        if (!IPConfig.getConfig().shaderpackWarning) {
            return;
        }
        String shaderpackName = IrisInterface.invoker.getShaderpackName();
        if (!Objects.equals(lastShaderpackName, shaderpackName)) {
            boolean incompatible;
            lastShaderpackName = shaderpackName;
            if (shaderpackName != null && incompatibleShaderpacks != null && (incompatible = incompatibleShaderpacks.stream().anyMatch(n -> shaderpackName.toLowerCase().contains(n.toLowerCase())))) {
                CHelper.printChat((class_2561)class_2561.method_43471((String)"imm_ptl.incompatible_shaderpack").method_27692(class_124.field_1061));
            }
        }
    }

    public static final class ImmPtlInfo {
        public String latestReleaseVersion;
        public List<String> previewVersions;
        public List<ModIncompatInfo> severelyIncompatible;
        public List<ModIncompatInfo> incompatible;
        public List<String> incompatibleShaderpacks;

        public ImmPtlInfo(String latestReleaseVersion, List<ModIncompatInfo> severelyIncompatible, List<ModIncompatInfo> incompatible) {
            this.latestReleaseVersion = latestReleaseVersion;
            this.severelyIncompatible = severelyIncompatible;
            this.incompatible = incompatible;
        }

        public String toString() {
            return "ImmPtlInfo{latestReleaseVersion='" + this.latestReleaseVersion + "', severelyIncompatible=" + String.valueOf(this.severelyIncompatible) + ", incompatible=" + String.valueOf(this.incompatible) + "}";
        }
    }

    public record ModIncompatInfo(String modId, String modName, @Nullable String startVersion, @Nullable String endVersion, @Nullable String desc, @Nullable String link) {
        boolean isModLoadedWithinVersion() {
            return O_O.isModLoadedWithinVersion(this.modId, this.startVersion, this.endVersion);
        }

        String getVersionRangeStr() {
            if (this.startVersion != null) {
                if (this.endVersion != null) {
                    return this.startVersion + "-" + this.endVersion;
                }
                return this.startVersion + "+";
            }
            Validate.notNull((Object)this.endVersion, (String)"invalid version range", (Object[])new Object[0]);
            return "-" + this.endVersion;
        }
    }
}

